from trex_stl_lib.api import *

class STLS1(object):

    def create_stream (self):

        pkt1 = Ether(src="00:11:11:5e:03:f0",dst="00:ab:ab:ab:03:f0") / Dot1Q(vlan = 1100) / IP(src="16.0.3.240",dst="32.0.3.240") / UDP(dport=12,sport=1025) / (10*'x')

        vm1 = STLScVmRaw( [ STLVmFlowVar(name = 'inc_var', min_value = 0, max_value = 20, size = 1, op = 'inc'),
                            STLVmWrFlowVar(fv_name = 'inc_var', pkt_offset = 'Ethernet.src', offset_fixup = 5, add_val = 240),
                            STLVmWrFlowVar(fv_name = 'inc_var', pkt_offset = 'Ethernet.dst', offset_fixup = 5, add_val = 240),
                            STLVmWrFlowVar(fv_name = 'inc_var', pkt_offset = '802|1Q.id', offset_fixup = 1, add_val = 1100),
                            STLVmWrFlowVar(fv_name = 'inc_var', pkt_offset = 'IP.src', offset_fixup = 3, add_val = 240),
                            STLVmWrFlowVar(fv_name = 'inc_var', pkt_offset = 'IP.dst', offset_fixup = 3, add_val = 240)])

        return STLStream( 
            packet = 
                    STLPktBuilder(
                        pkt =pkt1,
                        vm = vm1

                    ),
             mode = STLTXCont())

    def get_streams (self, direction = 0, **kwargs):
        # create 1 stream 
        return [ self.create_stream() ]


# dynamic load - used for trex console or simulator
def register():
    return STLS1()



