

# CHARACTERIZE VSWITCH PERFORMANCE FOR TELCO NFV USE CASES LEVEL TEST REPORT

## Table of Contents

- [1. Introduction](#Introduction)
  - [1.1. Document identifier](#DocId)
  - [1.2. Scope](#Scope)
  - [1.3. References](#References)
- [2. Details of the Level Test Report](#DetailsoftheLevelTestReport)
  - [2.1. Overview of test results](#OverviewOfTestResults)
  - [2.2. Detailed test results](#DetailedTestResults)
  - [2.3. Rationale for decisions](#RationaleForDecisions)
  - [2.4. Conclusions and recommendations](#ConclusionsandRecommendations)
- [3. General](#General)
  - [3.1. Glossary](#Glossary)
  - [3.2. Document change procedures and history](#DocChangeProceduresandHistory)

---

<a name="Introduction"></a>
## 1. Introduction

The objective of the OPNFV project titled **"Characterise vSwitch Performance
for Telco NFV Use Cases"**, is to evaluate a virtual switch to identify its
suitability for a Telco Network Function Virtualization (NFV) environment. As
well as this, the project aims to identify any gaps or bottlenecks in order to
drive architectural changes to improve virtual switch performance and
determinism. The purpose of this document is to summarize the results of the
tests carried out on the virtual switch in the Network Function Virtualization
Infrastructure (NFVI) and, from these results, provide evaluations and
recommendations for the virtual switch. Test results will be outlined in
[Details of the Level Test Report](#DetailsoftheLevelTestReport), preceded by
the [Document Identifier](#DocId), [Scope](#Scope) and
[References](#References).

This document is currently in draft form.

<a name="DocId"></a>
### 1.1. Document identifier

The document id will be used to uniquely identify versions of the LTR. The
format for the document id will be:
`OPNFV_vswitchperf_LTR_ver_NUM_MONTH_YEAR_AUTHOR_STATUS`, where by the AUTHOR
field should be replaced with the initials of the author and the status is one
of: DRAFT, REVIEWED, CORRECTED or FINAL. The document id for this version of
the LTR is: `OPNFV_vswitchperf_LTR_ver_1.1_Jan_15_CN_DRAFT`.

<a name="Scope"></a>
### 1.2. Scope

The scope of this report is to detail the results of the tests that have been
performed on the virtual switch. This report will also evaluate the results of
these tests and, based on these evaluations, provide recommendations on the
suitability of the virtual switch for use in a Telco NFV environment.

<a name="References"></a>
### 1.3. References

- `OPNFV_vswitchperf_LTD_ver_1.6_Jan_15_DRAFT`

---

<a name="DetailsoftheLevelTestReport"></a>
## 2. Details of the Level Test Report

This section provides an overview of the test results ([Section
2.1.](#OveriewOfTestResults)) as well as detailed test results for each test
([Section 2.2.](#DetailedTestResults)). Also included are the rationale used to
evaluate each test ([Section 2.3.](#RationaleForDecisions)) and the conclusions
and recommendations for each test ([Section
2.4.](#ConclusionsandRecommendations)).

<a name="OverviewOfTestResults"></a>
### 2.1. Overview of test results

##### Test Environment

Below is the environment that the test was performed in:

- OS: CentOS Linux 7 Core
- Kernel Version: 4.4.50-rt62-1704041234nfv
- NIC(s):
    - Intel Corporation 82599ES 10-Gigabit SFI/SFP+ Network Connection (rev 01)
    - Intel Corporation 82599ES 10-Gigabit SFI/SFP+ Network Connection (rev 01)
- Board: Intel Corporation S2600WT2R [2 sockets]
- CPU:  Intel(R) Xeon(R) CPU E5-2699 v4 @ 2.20GHz
- CPU cores: 44
- Memory: 65939100 kB
- Virtual Switch Set-up: p2p
- vswitchperf: GIT tag: 7c4a2cdcdd99f309dccfe0a24e829bbf3afa95f9
- Traffic Generator: IxNet, Version: 8.01.1029.6, GIT tag: None
- vSwitch: OvsDpdkVhost, Version: 2.6.90, GIT tag: ed26e3ea9995ba632e681d5990af5ee9814f650e
- DPDK Version: None, GIT tag: d3bfeaaabfd37ecc7d7d2edf2a3b60cc2d913cc9

For each test, a summary of the key test results is provided.

#### Test ID: PHY2PHY_TPUT

Below are test details:

- Test ID: phy2phy_tput
- Description: LTD.Throughput.RFC2544.PacketLossRatio
- Deployment: p2p
- Traffic type: rfc2544
- Packet size: 64
- Bidirectional : 


<a name="DetailedTestResults"></a>
### 2.2. Detailed test results

A detailed summary of the main results for each test is outlined below.

#### Test ID: PHY2PHY_TPUT

##### Results/Metrics Collected

The following are the metrics obtained during this test:

|             Metric             |             Result             |
| ------------------------------ | ------------------------------ |
| tx_rate_fps                    |                        Unknown |
| throughput_rx_fps              |                   23546938.568 |
| tx_rate_mbps                   |                        Unknown |
| throughput_rx_mbps             |                      12056.033 |
| tx_rate_percent                |                         79.117 |
| throughput_rx_percent          |                         79.117 |
| frame_loss_percent             |                          0.000 |
| min_latency_ns                 |                       4560.000 |
| max_latency_ns                 |                      20140.000 |
| avg_latency_ns                 |                       9705.000 |
| type                           |                        rfc2544 |
| packet_size                    |                             64 |
| traffic_type                   |                            udp |
| test_execution_time            |                       00:05:48 |

##### Statistics collected

The following system statistics were collected during testcase execution:

| Process: ovs-vswitchd                                           |
| ------------------------------ | ------------------------------ |
|           Statistic            |             Value              |
| ------------------------------ | ------------------------------ |
| UID                            |                              0 |
| PID                            |                          40703 |
| %usr                           |                         100.00 |
| %system                        |                           0.35 |
| %guest                         |                           0.00 |
| %CPU                           |                         100.00 |
| CPU                            |                              - |
| minflt/s                       |                           0.10 |
| majflt/s                       |                           0.00 |
| VSZ                            |                        1685744 |
| RSS                            |                          18514 |
| %MEM                           |                           0.03 |
| kB_rd/s                        |                           0.00 |
| kB_wr/s                        |                           0.00 |
| kB_ccwr/s                      |                           0.00 |


| Process: ovsdb-server                                           |
| ------------------------------ | ------------------------------ |
|           Statistic            |             Value              |
| ------------------------------ | ------------------------------ |
| UID                            |                              0 |
| PID                            |                          40687 |
| %usr                           |                           0.00 |
| %system                        |                           0.00 |
| %guest                         |                           0.00 |
| %CPU                           |                           0.00 |
| CPU                            |                              - |
| minflt/s                       |                           0.00 |
| majflt/s                       |                           0.00 |
| VSZ                            |                          20532 |
| RSS                            |                           3488 |
| %MEM                           |                           0.01 |
| kB_rd/s                        |                           0.00 |
| kB_wr/s                        |                           0.00 |
| kB_ccwr/s                      |                           0.00 |



##### Anomalies

No anomalies were detected during the course of this test.

##### Testing Activities/Events

There were no significant testing activities for this test.

<a name="RationaleForDecisions"></a>
### 2.3. Rationale for decisions

The tests conducted do not have pass/fail/conditional-pass criteria. The test
is simply conducted and the results are reported.


<a name="ConclusionsandRecommendations"></a>
### 2.4. Conclusions and recommendations

The test results are stable. The vsperf CI jobs that were used to obtain the
results can be found at https://wiki.opnfv.org/wiki/vsperf_results.

-----

<a name="General"></a>
## 3. General

<a name="Glossary"></a>
### 3.1. Glossary

- NFV - Network Function Virtualization
- Mbps - 1,000,000bps

<a name="DocChangeProceduresandHistory"></a>
### 3.2. Document change procedures and history

| Document ID | Author | Date Modified |
| ----------- |------- | ------------- |
| `OPNFV_vswitchperf_LTR_ver_1.0_Jan_15_CN_DRAFT` | Christopher Nolan | 23/01/2015
| `OPNFV_vswitchperf_LTR_ver_1.1_Jan_15_CN_DRAFT` | Christopher Nolan | 28/01/2015